#include "hal_data.h"
#include "debug_uart/debug_bsp_uart.h"
FSP_CPP_HEADER
void R_BSP_WarmStart(bsp_warm_start_event_t event);
FSP_CPP_FOOTER

volatile bool i2c_tx_complete = false;
volatile bool i2c_rx_complete = false;
void I2CWaitRX(void);
void I2CWaitRX(void){
    uint16_t t = 1000;
    while(!i2c_rx_complete && t){
        t--;
        R_BSP_SoftwareDelay(10, BSP_DELAY_UNITS_MICROSECONDS);
    }
    i2c_rx_complete = false;
}
void I2CWaitTX(void);
void I2CWaitTX(void){
    uint16_t t = 1000;
    while(!i2c_tx_complete && t){
        t--;
        R_BSP_SoftwareDelay(10, BSP_DELAY_UNITS_MICROSECONDS);
    }
    i2c_tx_complete = false;
}

void sci_i2c_master_callback(i2c_master_callback_args_t *p_args){
    if(p_args->event==I2C_MASTER_EVENT_TX_COMPLETE){
        i2c_tx_complete = true;
    }
    else if(p_args->event==I2C_MASTER_EVENT_RX_COMPLETE){
        i2c_rx_complete = true;
    }
}

/*******************************************************************************************************************//**
 * main() is generated by the RA Configuration editor and is used to generate threads if an RTOS is used.  This function
 * is called by main() when no RTOS is used.
 **********************************************************************************************************************/
void hal_entry(void)
{
    /* TODO: add your own code here */
    Debug_UART9_Init(); // SCI9 UART 调试串口初始化
    printf("I2C-BH1750光照传感器实验\r\n");
    R_SCI_I2C_Open(&g_i2c0_ctrl, &g_i2c0_cfg);

    uint8_t cmd = 0x01;

    R_SCI_I2C_Write(&g_i2c0_ctrl, &cmd, 1, false);
    I2CWaitTX();
    cmd = 0x10;
    R_SCI_I2C_Write(&g_i2c0_ctrl, &cmd, 1, false);
    I2CWaitTX();

    uint8_t data[2]={0};
    while(1){
        R_SCI_I2C_Read(&g_i2c0_ctrl, &data[0], 2, false);
        I2CWaitRX();

        int temp=(data[0]<<8)+data[1]; //2个字节合成数据
        double light=temp/1.2;//计算光照度
        printf("light: %.1f lux\r\n",light);
        R_BSP_SoftwareDelay(500,BSP_DELAY_UNITS_MILLISECONDS);
    }



#if BSP_TZ_SECURE_BUILD
    /* Enter non-secure code */
    R_BSP_NonSecureEnter();
#endif
}

/*******************************************************************************************************************//**
 * This function is called at various points during the startup process.  This implementation uses the event that is
 * called right before main() to set up the pins.
 *
 * @param[in]  event    Where at in the start up process the code is currently at
 **********************************************************************************************************************/
void R_BSP_WarmStart(bsp_warm_start_event_t event)
{
    if (BSP_WARM_START_RESET == event)
    {
#if BSP_FEATURE_FLASH_LP_VERSION != 0

        /* Enable reading from data flash. */
        R_FACI_LP->DFLCTL = 1U;

        /* Would normally have to wait tDSTOP(6us) for data flash recovery. Placing the enable here, before clock and
         * C runtime initialization, should negate the need for a delay since the initialization will typically take more than 6us. */
#endif
    }

    if (BSP_WARM_START_POST_C == event)
    {
        /* C runtime environment and system clocks are setup. */

        /* Configure pins. */
        R_IOPORT_Open (&IOPORT_CFG_CTRL, &IOPORT_CFG_NAME);

#if BSP_CFG_SDRAM_ENABLED

        /* Setup SDRAM and initialize it. Must configure pins first. */
        R_BSP_SdramInit(true);
#endif
    }
}

#if BSP_TZ_SECURE_BUILD

FSP_CPP_HEADER
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable ();

/* Trustzone Secure Projects require at least one nonsecure callable function in order to build (Remove this if it is not required to build). */
BSP_CMSE_NONSECURE_ENTRY void template_nonsecure_callable ()
{

}
FSP_CPP_FOOTER

#endif
